<?php
header('Content-Type: application/json');
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$method = $_SERVER['REQUEST_METHOD'];

try {
    switch($method) {
        case 'GET':
            if (isset($_GET['id'])) {
                // Obtener un cliente específico
                $stmt = $db->prepare("SELECT * FROM clientes WHERE id = ?");
                $stmt->execute([$_GET['id']]);
                $cliente = $stmt->fetch(PDO::FETCH_ASSOC);
                echo json_encode($cliente);
            } else {
                // Obtener lista de clientes con filtros
                $where = "WHERE activo = 1";
                $params = [];
                
                if (!empty($_GET['nombre'])) {
                    $where .= " AND (nombre LIKE ? OR apellido LIKE ?)";
                    $params[] = '%' . $_GET['nombre'] . '%';
                    $params[] = '%' . $_GET['nombre'] . '%';
                }
                
                if (!empty($_GET['documento'])) {
                    $where .= " AND documento LIKE ?";
                    $params[] = '%' . $_GET['documento'] . '%';
                }
                
                if (!empty($_GET['tipo_documento'])) {
                    $where .= " AND tipo_documento = ?";
                    $params[] = $_GET['tipo_documento'];
                }
                
                $stmt = $db->prepare("SELECT * FROM clientes $where ORDER BY nombre, apellido");
                $stmt->execute($params);
                $clientes = $stmt->fetchAll(PDO::FETCH_ASSOC);
                echo json_encode($clientes);
            }
            break;
            
        case 'POST':
            if (isset($_POST['id']) && !empty($_POST['id'])) {
                // Actualizar cliente existente
                $stmt = $db->prepare("
                    UPDATE clientes SET 
                        nombre = ?, apellido = ?, documento = ?, tipo_documento = ?, 
                        telefono = ?, email = ?, direccion = ?, fecha_nacimiento = ?
                    WHERE id = ?
                ");
                
                $result = $stmt->execute([
                    $_POST['nombre'],
                    $_POST['apellido'],
                    $_POST['documento'],
                    $_POST['tipo_documento'],
                    $_POST['telefono'],
                    $_POST['email'],
                    $_POST['direccion'],
                    !empty($_POST['fecha_nacimiento']) ? $_POST['fecha_nacimiento'] : null,
                    $_POST['id']
                ]);
                
                if ($result) {
                    echo json_encode(['success' => true, 'message' => 'Cliente actualizado correctamente']);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Error al actualizar el cliente']);
                }
            } else {
                // Crear nuevo cliente
                $stmt = $db->prepare("
                    INSERT INTO clientes (nombre, apellido, documento, tipo_documento, telefono, email, direccion, fecha_nacimiento)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?)
                ");
                
                $result = $stmt->execute([
                    $_POST['nombre'],
                    $_POST['apellido'],
                    $_POST['documento'],
                    $_POST['tipo_documento'],
                    $_POST['telefono'],
                    $_POST['email'],
                    $_POST['direccion'],
                    !empty($_POST['fecha_nacimiento']) ? $_POST['fecha_nacimiento'] : null
                ]);
                
                if ($result) {
                    echo json_encode(['success' => true, 'message' => 'Cliente creado correctamente']);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Error al crear el cliente']);
                }
            }
            break;
            
        case 'DELETE':
            $input = json_decode(file_get_contents('php://input'), true);
            if (!$input) {
                parse_str(file_get_contents('php://input'), $input);
            }
            
            $stmt = $db->prepare("UPDATE clientes SET activo = 0 WHERE id = ?");
            $result = $stmt->execute([$input['id']]);
            
            if ($result) {
                echo json_encode(['success' => true, 'message' => 'Cliente eliminado correctamente']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al eliminar el cliente']);
            }
            break;
    }
} catch(PDOException $exception) {
    echo json_encode(['success' => false, 'message' => 'Error de base de datos: ' . $exception->getMessage()]);
}
?>