<?php
header('Content-Type: application/json');
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$method = $_SERVER['REQUEST_METHOD'];

try {
    switch($method) {
        case 'GET':
            if (isset($_GET['action'])) {
                switch($_GET['action']) {
                    case 'resumen':
                        // Obtener resumen del inventario
                        $stmt = $db->prepare("SELECT COUNT(*) as total FROM productos WHERE activo = 1");
                        $stmt->execute();
                        $total_productos = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
                        
                        $stmt = $db->prepare("SELECT COUNT(*) as total FROM productos WHERE stock_actual <= stock_minimo AND activo = 1");
                        $stmt->execute();
                        $stock_bajo = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
                        
                        $stmt = $db->prepare("SELECT COUNT(*) as total FROM productos WHERE stock_actual = 0 AND activo = 1");
                        $stmt->execute();
                        $sin_stock = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
                        
                        $stmt = $db->prepare("SELECT COALESCE(SUM(stock_actual * precio_compra), 0) as valor FROM productos WHERE activo = 1");
                        $stmt->execute();
                        $valor_inventario = $stmt->fetch(PDO::FETCH_ASSOC)['valor'];
                        
                        echo json_encode([
                            'total_productos' => $total_productos,
                            'stock_bajo' => $stock_bajo,
                            'sin_stock' => $sin_stock,
                            'valor_inventario' => $valor_inventario
                        ]);
                        break;
                        
                    case 'movimientos':
                        // Obtener movimientos de inventario
                        $where = "WHERE 1=1";
                        $params = [];
                        
                        if (!empty($_GET['fecha_inicio'])) {
                            $where .= " AND DATE(mi.fecha) >= ?";
                            $params[] = $_GET['fecha_inicio'];
                        }
                        
                        if (!empty($_GET['fecha_fin'])) {
                            $where .= " AND DATE(mi.fecha) <= ?";
                            $params[] = $_GET['fecha_fin'];
                        }
                        
                        if (!empty($_GET['tipo'])) {
                            $where .= " AND mi.tipo_movimiento = ?";
                            $params[] = $_GET['tipo'];
                        }
                        
                        $stmt = $db->prepare("
                            SELECT mi.*, p.nombre as producto_nombre, u.nombre as usuario_nombre
                            FROM movimientos_inventario mi
                            JOIN productos p ON mi.producto_id = p.id
                            JOIN usuarios u ON mi.usuario_id = u.id
                            $where
                            ORDER BY mi.fecha DESC
                            LIMIT 100
                        ");
                        $stmt->execute($params);
                        $movimientos = $stmt->fetchAll(PDO::FETCH_ASSOC);
                        echo json_encode($movimientos);
                        break;
                        
                    case 'stock_bajo':
                        // Obtener productos con stock bajo
                        $stmt = $db->prepare("SELECT * FROM productos_stock_bajo");
                        $stmt->execute();
                        $productos = $stmt->fetchAll(PDO::FETCH_ASSOC);
                        echo json_encode($productos);
                        break;
                }
            } else {
                // Obtener inventario general
                $where = "WHERE p.activo = 1";
                $params = [];
                
                if (!empty($_GET['nombre'])) {
                    $where .= " AND p.nombre LIKE ?";
                    $params[] = '%' . $_GET['nombre'] . '%';
                }
                
                if (!empty($_GET['categoria'])) {
                    $where .= " AND p.categoria_id = ?";
                    $params[] = $_GET['categoria'];
                }
                
                $stmt = $db->prepare("
                    SELECT p.*, c.nombre as categoria_nombre
                    FROM productos p
                    LEFT JOIN categorias c ON p.categoria_id = c.id
                    $where
                    ORDER BY p.nombre
                ");
                $stmt->execute($params);
                $productos = $stmt->fetchAll(PDO::FETCH_ASSOC);
                echo json_encode($productos);
            }
            break;
            
        case 'POST':
            // Crear movimiento de inventario
            $producto_id = $_POST['producto_id'];
            $tipo_movimiento = $_POST['tipo_movimiento'];
            $cantidad = floatval($_POST['cantidad']);
            $motivo = $_POST['motivo'];
            $usuario_id = $_POST['usuario_id'];
            
            // Iniciar transacción
            $db->beginTransaction();
            
            // Obtener stock actual del producto
            $stmt = $db->prepare("SELECT stock_actual FROM productos WHERE id = ?");
            $stmt->execute([$producto_id]);
            $stock_actual = $stmt->fetch(PDO::FETCH_ASSOC)['stock_actual'];
            
            // Calcular nuevo stock
            $nuevo_stock = $stock_actual;
            switch($tipo_movimiento) {
                case 'entrada':
                case 'devolucion':
                    $nuevo_stock += $cantidad;
                    break;
                case 'salida':
                    $nuevo_stock -= $cantidad;
                    break;
                case 'ajuste':
                    $nuevo_stock = $cantidad; // En ajuste, la cantidad es el nuevo stock
                    $cantidad = $cantidad - $stock_actual; // Calcular diferencia para el registro
                    break;
            }
            
            // Validar que el stock no sea negativo
            if ($nuevo_stock < 0) {
                throw new Exception("No hay suficiente stock disponible");
            }
            
            // Actualizar stock del producto
            $stmt = $db->prepare("UPDATE productos SET stock_actual = ? WHERE id = ?");
            $stmt->execute([$nuevo_stock, $producto_id]);
            
            // Registrar movimiento
            $stmt = $db->prepare("
                INSERT INTO movimientos_inventario (producto_id, tipo_movimiento, cantidad, motivo, usuario_id)
                VALUES (?, ?, ?, ?, ?)
            ");
            $stmt->execute([$producto_id, $tipo_movimiento, $cantidad, $motivo, $usuario_id]);
            
            // Confirmar transacción
            $db->commit();
            
            echo json_encode(['success' => true, 'message' => 'Movimiento registrado correctamente']);
            break;
    }
} catch(Exception $exception) {
    if ($db->inTransaction()) {
        $db->rollback();
    }
    echo json_encode(['success' => false, 'message' => $exception->getMessage()]);
}
?>