<?php
header('Content-Type: application/json');
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$method = $_SERVER['REQUEST_METHOD'];

try {
    switch($method) {
        case 'GET':
            if (isset($_GET['id'])) {
                // Obtener un producto específico
                $stmt = $db->prepare("
                    SELECT p.*, c.nombre as categoria_nombre, pr.nombre as proveedor_nombre 
                    FROM productos p 
                    LEFT JOIN categorias c ON p.categoria_id = c.id 
                    LEFT JOIN proveedores pr ON p.proveedor_id = pr.id 
                    WHERE p.id = ?
                ");
                $stmt->execute([$_GET['id']]);
                $producto = $stmt->fetch(PDO::FETCH_ASSOC);
                echo json_encode($producto);
            } else {
                // Obtener lista de productos con filtros
                $where = "WHERE p.activo = 1";
                $params = [];
                
                if (!empty($_GET['nombre'])) {
                    $where .= " AND p.nombre LIKE ?";
                    $params[] = '%' . $_GET['nombre'] . '%';
                }
                
                if (!empty($_GET['categoria'])) {
                    $where .= " AND p.categoria_id = ?";
                    $params[] = $_GET['categoria'];
                }
                
                if (!empty($_GET['stock'])) {
                    if ($_GET['stock'] == 'bajo') {
                        $where .= " AND p.stock_actual <= p.stock_minimo";
                    } elseif ($_GET['stock'] == 'sin_stock') {
                        $where .= " AND p.stock_actual = 0";
                    }
                }
                
                $stmt = $db->prepare("
                    SELECT p.*, c.nombre as categoria_nombre, pr.nombre as proveedor_nombre 
                    FROM productos p 
                    LEFT JOIN categorias c ON p.categoria_id = c.id 
                    LEFT JOIN proveedores pr ON p.proveedor_id = pr.id 
                    $where 
                    ORDER BY p.nombre
                ");
                $stmt->execute($params);
                $productos = $stmt->fetchAll(PDO::FETCH_ASSOC);
                echo json_encode($productos);
            }
            break;
            
        case 'POST':
            if (isset($_POST['id']) && !empty($_POST['id'])) {
                // Actualizar producto existente
                $stmt = $db->prepare("
                    UPDATE productos SET 
                        codigo_barras = ?, nombre = ?, descripcion = ?, precio_compra = ?, 
                        precio_venta = ?, stock_actual = ?, stock_minimo = ?, stock_maximo = ?, 
                        categoria_id = ?, proveedor_id = ?, unidad_medida = ?, imagen = ?, 
                        fecha_vencimiento = ?
                    WHERE id = ?
                ");
                
                $result = $stmt->execute([
                    $_POST['codigo_barras'],
                    $_POST['nombre'],
                    $_POST['descripcion'],
                    $_POST['precio_compra'],
                    $_POST['precio_venta'],
                    $_POST['stock_actual'],
                    $_POST['stock_minimo'],
                    $_POST['stock_maximo'],
                    !empty($_POST['categoria_id']) ? $_POST['categoria_id'] : null,
                    !empty($_POST['proveedor_id']) ? $_POST['proveedor_id'] : null,
                    $_POST['unidad_medida'],
                    $_POST['imagen'],
                    !empty($_POST['fecha_vencimiento']) ? $_POST['fecha_vencimiento'] : null,
                    $_POST['id']
                ]);
                
                if ($result) {
                    echo json_encode(['success' => true, 'message' => 'Producto actualizado correctamente']);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Error al actualizar el producto']);
                }
            } else {
                // Crear nuevo producto
                $stmt = $db->prepare("
                    INSERT INTO productos (
                        codigo_barras, nombre, descripcion, precio_compra, precio_venta, 
                        stock_actual, stock_minimo, stock_maximo, categoria_id, proveedor_id, 
                        unidad_medida, imagen, fecha_vencimiento
                    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
                ");
                
                $result = $stmt->execute([
                    $_POST['codigo_barras'],
                    $_POST['nombre'],
                    $_POST['descripcion'],
                    $_POST['precio_compra'],
                    $_POST['precio_venta'],
                    $_POST['stock_actual'],
                    $_POST['stock_minimo'],
                    $_POST['stock_maximo'],
                    !empty($_POST['categoria_id']) ? $_POST['categoria_id'] : null,
                    !empty($_POST['proveedor_id']) ? $_POST['proveedor_id'] : null,
                    $_POST['unidad_medida'],
                    $_POST['imagen'],
                    !empty($_POST['fecha_vencimiento']) ? $_POST['fecha_vencimiento'] : null
                ]);
                
                if ($result) {
                    echo json_encode(['success' => true, 'message' => 'Producto creado correctamente']);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Error al crear el producto']);
                }
            }
            break;
            
        case 'DELETE':
            $input = json_decode(file_get_contents('php://input'), true);
            if (!$input) {
                parse_str(file_get_contents('php://input'), $input);
            }
            
            $stmt = $db->prepare("UPDATE productos SET activo = 0 WHERE id = ?");
            $result = $stmt->execute([$input['id']]);
            
            if ($result) {
                echo json_encode(['success' => true, 'message' => 'Producto eliminado correctamente']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al eliminar el producto']);
            }
            break;
    }
} catch(PDOException $exception) {
    echo json_encode(['success' => false, 'message' => 'Error de base de datos: ' . $exception->getMessage()]);
}
?>