<?php
header('Content-Type: application/json');
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$method = $_SERVER['REQUEST_METHOD'];

try {
    switch($method) {
        case 'GET':
            if (isset($_GET['id'])) {
                // Obtener un proveedor específico
                $stmt = $db->prepare("SELECT * FROM proveedores WHERE id = ?");
                $stmt->execute([$_GET['id']]);
                $proveedor = $stmt->fetch(PDO::FETCH_ASSOC);
                echo json_encode($proveedor);
            } else {
                // Obtener lista de proveedores con filtros
                $where = "WHERE activo = 1";
                $params = [];
                
                if (!empty($_GET['nombre'])) {
                    $where .= " AND nombre LIKE ?";
                    $params[] = '%' . $_GET['nombre'] . '%';
                }
                
                if (!empty($_GET['contacto'])) {
                    $where .= " AND contacto LIKE ?";
                    $params[] = '%' . $_GET['contacto'] . '%';
                }
                
                $stmt = $db->prepare("SELECT * FROM proveedores $where ORDER BY nombre");
                $stmt->execute($params);
                $proveedores = $stmt->fetchAll(PDO::FETCH_ASSOC);
                echo json_encode($proveedores);
            }
            break;
            
        case 'POST':
            if (isset($_POST['id']) && !empty($_POST['id'])) {
                // Actualizar proveedor existente
                $stmt = $db->prepare("
                    UPDATE proveedores SET 
                        nombre = ?, contacto = ?, telefono = ?, email = ?, direccion = ?
                    WHERE id = ?
                ");
                
                $result = $stmt->execute([
                    $_POST['nombre'],
                    $_POST['contacto'],
                    $_POST['telefono'],
                    $_POST['email'],
                    $_POST['direccion'],
                    $_POST['id']
                ]);
                
                if ($result) {
                    echo json_encode(['success' => true, 'message' => 'Proveedor actualizado correctamente']);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Error al actualizar el proveedor']);
                }
            } else {
                // Crear nuevo proveedor
                $stmt = $db->prepare("
                    INSERT INTO proveedores (nombre, contacto, telefono, email, direccion)
                    VALUES (?, ?, ?, ?, ?)
                ");
                
                $result = $stmt->execute([
                    $_POST['nombre'],
                    $_POST['contacto'],
                    $_POST['telefono'],
                    $_POST['email'],
                    $_POST['direccion']
                ]);
                
                if ($result) {
                    echo json_encode(['success' => true, 'message' => 'Proveedor creado correctamente']);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Error al crear el proveedor']);
                }
            }
            break;
            
        case 'DELETE':
            $input = json_decode(file_get_contents('php://input'), true);
            if (!$input) {
                parse_str(file_get_contents('php://input'), $input);
            }
            
            $stmt = $db->prepare("UPDATE proveedores SET activo = 0 WHERE id = ?");
            $result = $stmt->execute([$input['id']]);
            
            if ($result) {
                echo json_encode(['success' => true, 'message' => 'Proveedor eliminado correctamente']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al eliminar el proveedor']);
            }
            break;
    }
} catch(PDOException $exception) {
    echo json_encode(['success' => false, 'message' => 'Error de base de datos: ' . $exception->getMessage()]);
}
?>