<?php
header('Content-Type: application/json');
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

try {
    $action = $_GET['action'] ?? '';
    
    switch($action) {
        case 'ventas':
            $fecha_inicio = $_GET['fecha_inicio'] ?? date('Y-m-01');
            $fecha_fin = $_GET['fecha_fin'] ?? date('Y-m-d');
            $vendedor_id = $_GET['vendedor_id'] ?? '';
            
            $where = "WHERE DATE(fecha) BETWEEN ? AND ? AND estado = 'completada'";
            $params = [$fecha_inicio, $fecha_fin];
            
            if (!empty($vendedor_id)) {
                $where .= " AND vendedor_id = ?";
                $params[] = $vendedor_id;
            }
            
            // Resumen
            $stmt = $db->prepare("
                SELECT 
                    COUNT(*) as total_ventas,
                    COALESCE(SUM(total), 0) as monto_total,
                    COALESCE(AVG(total), 0) as promedio_venta,
                    COALESCE(SUM(descuento), 0) as total_descuentos
                FROM ventas $where
            ");
            $stmt->execute($params);
            $resumen = $stmt->fetch(PDO::FETCH_ASSOC);
            
            // Detalle por día
            $stmt = $db->prepare("
                SELECT 
                    DATE(fecha) as fecha,
                    COUNT(*) as num_ventas,
                    SUM(total) as total_ventas
                FROM ventas $where
                GROUP BY DATE(fecha)
                ORDER BY DATE(fecha)
            ");
            $stmt->execute($params);
            $detalle = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            echo json_encode([
                'resumen' => $resumen,
                'detalle' => $detalle
            ]);
            break;
            
        case 'productos':
            $categoria = $_GET['categoria'] ?? '';
            $tipo = $_GET['tipo'] ?? 'mas_vendidos';
            
            switch($tipo) {
                case 'mas_vendidos':
                    $sql = "SELECT * FROM productos_mas_vendidos";
                    if (!empty($categoria)) {
                        $sql .= " WHERE categoria_id = ?";
                        $params = [$categoria];
                    } else {
                        $params = [];
                    }
                    $sql .= " LIMIT 20";
                    break;
                    
                case 'stock_bajo':
                    $sql = "SELECT * FROM productos_stock_bajo";
                    if (!empty($categoria)) {
                        $sql .= " WHERE categoria_id = ?";
                        $params = [$categoria];
                    } else {
                        $params = [];
                    }
                    break;
                    
                default:
                    $sql = "SELECT * FROM productos_mas_vendidos LIMIT 20";
                    $params = [];
            }
            
            $stmt = $db->prepare($sql);
            $stmt->execute($params);
            $productos = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            echo json_encode($productos);
            break;
            
        case 'inventario':
            $tipo_movimiento = $_GET['tipo_movimiento'] ?? '';
            $fecha_inicio = $_GET['fecha_inicio'] ?? date('Y-m-01');
            $fecha_fin = $_GET['fecha_fin'] ?? date('Y-m-d');
            
            $where = "WHERE DATE(mi.fecha) BETWEEN ? AND ?";
            $params = [$fecha_inicio, $fecha_fin];
            
            if (!empty($tipo_movimiento)) {
                $where .= " AND mi.tipo_movimiento = ?";
                $params[] = $tipo_movimiento;
            }
            
            $stmt = $db->prepare("
                SELECT mi.*, p.nombre as producto_nombre, u.nombre as usuario_nombre
                FROM movimientos_inventario mi
                JOIN productos p ON mi.producto_id = p.id
                JOIN usuarios u ON mi.usuario_id = u.id
                $where
                ORDER BY mi.fecha DESC
                LIMIT 500
            ");
            $stmt->execute($params);
            $movimientos = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            echo json_encode($movimientos);
            break;
            
        case 'financiero':
            $fecha_inicio = $_GET['fecha_inicio'] ?? date('Y-m-01');
            $fecha_fin = $_GET['fecha_fin'] ?? date('Y-m-d');
            
            // Ingresos (ventas)
            $stmt = $db->prepare("
                SELECT COALESCE(SUM(total), 0) as total_ingresos
                FROM ventas 
                WHERE DATE(fecha) BETWEEN ? AND ? AND estado = 'completada'
            ");
            $stmt->execute([$fecha_inicio, $fecha_fin]);
            $ingresos = $stmt->fetch(PDO::FETCH_ASSOC)['total_ingresos'];
            
            // Gastos
            $stmt = $db->prepare("
                SELECT COALESCE(SUM(monto), 0) as total_gastos
                FROM gastos 
                WHERE fecha BETWEEN ? AND ?
            ");
            $stmt->execute([$fecha_inicio, $fecha_fin]);
            $gastos = $stmt->fetch(PDO::FETCH_ASSOC)['total_gastos'];
            
            $utilidad_bruta = $ingresos - $gastos;
            $margen_utilidad = $ingresos > 0 ? ($utilidad_bruta / $ingresos) * 100 : 0;
            
            echo json_encode([
                'total_ingresos' => $ingresos,
                'total_gastos' => $gastos,
                'utilidad_bruta' => $utilidad_bruta,
                'margen_utilidad' => $margen_utilidad
            ]);
            break;
            
        default:
            echo json_encode(['error' => 'Acción no válida']);
    }
    
} catch(PDOException $exception) {
    echo json_encode(['error' => 'Error de base de datos: ' . $exception->getMessage()]);
}
?>