<?php
header('Content-Type: application/json');
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$method = $_SERVER['REQUEST_METHOD'];

try {
    switch($method) {
        case 'GET':
            if (isset($_GET['id'])) {
                // Obtener un usuario específico
                $stmt = $db->prepare("SELECT id, nombre, apellido, username, email, rol, telefono, activo, ultimo_acceso FROM usuarios WHERE id = ?");
                $stmt->execute([$_GET['id']]);
                $usuario = $stmt->fetch(PDO::FETCH_ASSOC);
                echo json_encode($usuario);
            } else {
                // Obtener lista de usuarios con filtros
                $where = "WHERE 1=1";
                $params = [];
                
                if (!empty($_GET['nombre'])) {
                    $where .= " AND (nombre LIKE ? OR apellido LIKE ?)";
                    $params[] = '%' . $_GET['nombre'] . '%';
                    $params[] = '%' . $_GET['nombre'] . '%';
                }
                
                if (!empty($_GET['username'])) {
                    $where .= " AND username LIKE ?";
                    $params[] = '%' . $_GET['username'] . '%';
                }
                
                if (!empty($_GET['rol'])) {
                    $where .= " AND rol = ?";
                    $params[] = $_GET['rol'];
                }
                
                $stmt = $db->prepare("SELECT id, nombre, apellido, username, email, rol, telefono, activo, ultimo_acceso FROM usuarios $where ORDER BY nombre, apellido");
                $stmt->execute($params);
                $usuarios = $stmt->fetchAll(PDO::FETCH_ASSOC);
                echo json_encode($usuarios);
            }
            break;
            
        case 'POST':
            if (isset($_POST['id']) && !empty($_POST['id'])) {
                // Actualizar usuario existente
                $sql = "UPDATE usuarios SET nombre = ?, apellido = ?, username = ?, email = ?, rol = ?, telefono = ?";
                $params = [
                    $_POST['nombre'],
                    $_POST['apellido'],
                    $_POST['username'],
                    $_POST['email'],
                    $_POST['rol'],
                    $_POST['telefono']
                ];
                
                // Solo actualizar contraseña si se proporciona
                if (!empty($_POST['password'])) {
                    $sql .= ", password = ?";
                    $params[] = password_hash($_POST['password'], PASSWORD_DEFAULT);
                }
                
                $sql .= " WHERE id = ?";
                $params[] = $_POST['id'];
                
                $stmt = $db->prepare($sql);
                $result = $stmt->execute($params);
                
                if ($result) {
                    echo json_encode(['success' => true, 'message' => 'Usuario actualizado correctamente']);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Error al actualizar el usuario']);
                }
            } else {
                // Crear nuevo usuario
                // Verificar si el username ya existe
                $stmt = $db->prepare("SELECT COUNT(*) FROM usuarios WHERE username = ?");
                $stmt->execute([$_POST['username']]);
                if ($stmt->fetchColumn() > 0) {
                    echo json_encode(['success' => false, 'message' => 'El nombre de usuario ya existe']);
                    break;
                }
                
                $stmt = $db->prepare("
                    INSERT INTO usuarios (nombre, apellido, username, email, password, rol, telefono)
                    VALUES (?, ?, ?, ?, ?, ?, ?)
                ");
                
                $result = $stmt->execute([
                    $_POST['nombre'],
                    $_POST['apellido'],
                    $_POST['username'],
                    $_POST['email'],
                    password_hash($_POST['password'], PASSWORD_DEFAULT),
                    $_POST['rol'],
                    $_POST['telefono']
                ]);
                
                if ($result) {
                    echo json_encode(['success' => true, 'message' => 'Usuario creado correctamente']);
                } else {
                    echo json_encode(['success' => false, 'message' => 'Error al crear el usuario']);
                }
            }
            break;
            
        case 'DELETE':
            $input = json_decode(file_get_contents('php://input'), true);
            if (!$input) {
                parse_str(file_get_contents('php://input'), $input);
            }
            
            $stmt = $db->prepare("UPDATE usuarios SET activo = 0 WHERE id = ?");
            $result = $stmt->execute([$input['id']]);
            
            if ($result) {
                echo json_encode(['success' => true, 'message' => 'Usuario eliminado correctamente']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al eliminar el usuario']);
            }
            break;
    }
} catch(PDOException $exception) {
    echo json_encode(['success' => false, 'message' => 'Error de base de datos: ' . $exception->getMessage()]);
}
?>