<?php
header('Content-Type: application/json');
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$method = $_SERVER['REQUEST_METHOD'];

try {
    switch($method) {
        case 'POST':
            $input = json_decode(file_get_contents('php://input'), true);
            
            // Iniciar transacción
            $db->beginTransaction();
            
            // Crear la venta
            $stmt = $db->prepare("
                INSERT INTO ventas (vendedor_id, subtotal, descuento, total, metodo_pago) 
                VALUES (1, ?, ?, ?, ?)
            ");
            
            $subtotal = $input['subtotal'];
            $descuento = $input['descuento'];
            $total = $input['total'];
            $metodo_pago = $input['metodo_pago'];
            
            $stmt->execute([$subtotal, $descuento, $total, $metodo_pago]);
            $venta_id = $db->lastInsertId();
            
            // Obtener el número de venta generado
            $stmt = $db->prepare("SELECT numero_venta FROM ventas WHERE id = ?");
            $stmt->execute([$venta_id]);
            $numero_venta = $stmt->fetch(PDO::FETCH_ASSOC)['numero_venta'];
            
            // Agregar los items de la venta
            foreach($input['items'] as $item) {
                $stmt = $db->prepare("
                    INSERT INTO detalle_venta (venta_id, producto_id, cantidad, precio_unitario, descuento_unitario, subtotal) 
                    VALUES (?, ?, ?, ?, ?, ?)
                ");
                
                $item_subtotal = ($item['precio_unitario'] - $item['descuento_unitario']) * $item['cantidad'];
                
                $stmt->execute([
                    $venta_id,
                    $item['id'],
                    $item['cantidad'],
                    $item['precio_unitario'],
                    $item['descuento_unitario'],
                    $item_subtotal
                ]);
            }
            
            // Confirmar transacción
            $db->commit();
            
            echo json_encode([
                'success' => true, 
                'message' => 'Venta procesada correctamente',
                'numero_venta' => $numero_venta,
                'venta_id' => $venta_id
            ]);
            break;
            
        case 'GET':
            if (isset($_GET['id'])) {
                // Obtener una venta específica con sus detalles
                $stmt = $db->prepare("
                    SELECT v.*, u.nombre as vendedor_nombre, c.nombre as cliente_nombre
                    FROM ventas v
                    LEFT JOIN usuarios u ON v.vendedor_id = u.id
                    LEFT JOIN clientes c ON v.cliente_id = c.id
                    WHERE v.id = ?
                ");
                $stmt->execute([$_GET['id']]);
                $venta = $stmt->fetch(PDO::FETCH_ASSOC);
                
                // Obtener detalles de la venta
                $stmt = $db->prepare("
                    SELECT dv.*, p.nombre as producto_nombre, p.imagen
                    FROM detalle_venta dv
                    JOIN productos p ON dv.producto_id = p.id
                    WHERE dv.venta_id = ?
                ");
                $stmt->execute([$_GET['id']]);
                $detalles = $stmt->fetchAll(PDO::FETCH_ASSOC);
                
                $venta['detalles'] = $detalles;
                echo json_encode($venta);
            } else {
                // Obtener lista de ventas
                $where = "WHERE 1=1";
                $params = [];
                
                if (!empty($_GET['fecha_inicio'])) {
                    $where .= " AND DATE(v.fecha) >= ?";
                    $params[] = $_GET['fecha_inicio'];
                }
                
                if (!empty($_GET['fecha_fin'])) {
                    $where .= " AND DATE(v.fecha) <= ?";
                    $params[] = $_GET['fecha_fin'];
                }
                
                if (!empty($_GET['estado'])) {
                    $where .= " AND v.estado = ?";
                    $params[] = $_GET['estado'];
                }
                
                $stmt = $db->prepare("
                    SELECT v.*, u.nombre as vendedor_nombre, c.nombre as cliente_nombre
                    FROM ventas v
                    LEFT JOIN usuarios u ON v.vendedor_id = u.id
                    LEFT JOIN clientes c ON v.cliente_id = c.id
                    $where
                    ORDER BY v.fecha DESC
                    LIMIT 100
                ");
                $stmt->execute($params);
                $ventas = $stmt->fetchAll(PDO::FETCH_ASSOC);
                echo json_encode($ventas);
            }
            break;
    }
} catch(PDOException $exception) {
    if ($db->inTransaction()) {
        $db->rollback();
    }
    echo json_encode(['success' => false, 'message' => 'Error de base de datos: ' . $exception->getMessage()]);
}
?>