<?php
require_once 'config/database.php';
include 'includes/header.php';

$database = new Database();
$db = $database->getConnection();
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="fas fa-users me-2"></i>Gestión de Clientes</h1>
    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalCliente">
        <i class="fas fa-plus me-1"></i>Nuevo Cliente
    </button>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <div class="row">
            <div class="col-md-4">
                <input type="text" class="form-control" id="filtroNombre" placeholder="Buscar por nombre...">
            </div>
            <div class="col-md-3">
                <input type="text" class="form-control" id="filtroDocumento" placeholder="Buscar por documento...">
            </div>
            <div class="col-md-3">
                <select class="form-select" id="filtroTipoDocumento">
                    <option value="">Todos los tipos</option>
                    <option value="DPI">DPI</option>
                    <option value="NIT">NIT</option>
                    <option value="PASAPORTE">Pasaporte</option>
                </select>
            </div>
            <div class="col-md-2">
                <button type="button" class="btn btn-outline-primary w-100" onclick="cargarClientes()">
                    <i class="fas fa-search"></i> Buscar
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Tabla de clientes -->
<div class="card">
    <div class="card-body">
        <div class="loading">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">Cargando...</span>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table table-hover" id="tablaClientes">
                <thead>
                    <tr>
                        <th>Nombre</th>
                        <th>Documento</th>
                        <th>Teléfono</th>
                        <th>Email</th>
                        <th>Dirección</th>
                        <th>Estado</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody id="cuerpoTablaClientes">
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal para agregar/editar cliente -->
<div class="modal fade" id="modalCliente" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="tituloModal">Nuevo Cliente</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="formCliente">
                <div class="modal-body">
                    <input type="hidden" id="clienteId" name="id">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="nombre" class="form-label">Nombre *</label>
                                <input type="text" class="form-control" id="nombre" name="nombre" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="apellido" class="form-label">Apellido</label>
                                <input type="text" class="form-control" id="apellido" name="apellido">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="documento" class="form-label">Documento</label>
                                <input type="text" class="form-control" id="documento" name="documento">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="tipoDocumento" class="form-label">Tipo de Documento</label>
                                <select class="form-select" id="tipoDocumento" name="tipo_documento">
                                    <option value="DPI">DPI</option>
                                    <option value="NIT">NIT</option>
                                    <option value="PASAPORTE">Pasaporte</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="telefono" class="form-label">Teléfono</label>
                                <input type="tel" class="form-control" id="telefono" name="telefono">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" class="form-control" id="email" name="email">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="direccion" class="form-label">Dirección</label>
                        <textarea class="form-control" id="direccion" name="direccion" rows="3"></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="fechaNacimiento" class="form-label">Fecha de Nacimiento</label>
                        <input type="date" class="form-control" id="fechaNacimiento" name="fecha_nacimiento">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    cargarClientes();
    
    $('#filtroNombre, #filtroDocumento').on('keyup', function() {
        cargarClientes();
    });
});

function cargarClientes() {
    showLoading();
    
    const filtros = {
        nombre: $('#filtroNombre').val(),
        documento: $('#filtroDocumento').val(),
        tipo_documento: $('#filtroTipoDocumento').val()
    };
    
    $.ajax({
        url: 'api/clientes.php',
        method: 'GET',
        data: filtros,
        success: function(response) {
            const clientes = JSON.parse(response);
            let html = '';
            
            clientes.forEach(function(cliente) {
                const estadoBadge = cliente.activo == 1 ? '<span class="badge bg-success">Activo</span>' : '<span class="badge bg-danger">Inactivo</span>';
                
                html += `
                    <tr>
                        <td>
                            <strong>${cliente.nombre} ${cliente.apellido || ''}</strong>
                        </td>
                        <td>
                            ${cliente.documento || 'N/A'}
                            ${cliente.tipo_documento ? '<br><small class="text-muted">' + cliente.tipo_documento + '</small>' : ''}
                        </td>
                        <td>${cliente.telefono || 'N/A'}</td>
                        <td>${cliente.email || 'N/A'}</td>
                        <td>${cliente.direccion || 'N/A'}</td>
                        <td>${estadoBadge}</td>
                        <td>
                            <button class="btn btn-sm btn-outline-primary" onclick="editarCliente(${cliente.id})">
                                <i class="fas fa-edit"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-danger" onclick="eliminarCliente(${cliente.id})">
                                <i class="fas fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                `;
            });
            
            $('#cuerpoTablaClientes').html(html);
            hideLoading();
        },
        error: function() {
            showAlert('error', 'Error', 'No se pudieron cargar los clientes');
            hideLoading();
        }
    });
}

$('#formCliente').on('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    $.ajax({
        url: 'api/clientes.php',
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            const result = JSON.parse(response);
            if (result.success) {
                showAlert('success', 'Éxito', result.message);
                $('#modalCliente').modal('hide');
                $('#formCliente')[0].reset();
                cargarClientes();
            } else {
                showAlert('error', 'Error', result.message);
            }
        },
        error: function() {
            showAlert('error', 'Error', 'No se pudo guardar el cliente');
        }
    });
});

function editarCliente(id) {
    $.ajax({
        url: 'api/clientes.php?id=' + id,
        method: 'GET',
        success: function(response) {
            const cliente = JSON.parse(response);
            
            $('#clienteId').val(cliente.id);
            $('#nombre').val(cliente.nombre);
            $('#apellido').val(cliente.apellido);
            $('#documento').val(cliente.documento);
            $('#tipoDocumento').val(cliente.tipo_documento);
            $('#telefono').val(cliente.telefono);
            $('#email').val(cliente.email);
            $('#direccion').val(cliente.direccion);
            $('#fechaNacimiento').val(cliente.fecha_nacimiento);
            
            $('#tituloModal').text('Editar Cliente');
            $('#modalCliente').modal('show');
        }
    });
}

function eliminarCliente(id) {
    confirmAction('¿Eliminar cliente?', 'Esta acción no se puede deshacer', function() {
        $.ajax({
            url: 'api/clientes.php',
            method: 'DELETE',
            data: { id: id },
            success: function(response) {
                const result = JSON.parse(response);
                if (result.success) {
                    showAlert('success', 'Éxito', result.message);
                    cargarClientes();
                } else {
                    showAlert('error', 'Error', result.message);
                }
            }
        });
    });
}

$('#modalCliente').on('hidden.bs.modal', function() {
    $('#formCliente')[0].reset();
    $('#clienteId').val('');
    $('#tituloModal').text('Nuevo Cliente');
});
</script>

<?php include 'includes/footer.php'; ?>