<?php
require_once 'config/database.php';
include 'includes/header.php';

$database = new Database();
$db = $database->getConnection();
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="fas fa-warehouse me-2"></i>Gestión de Inventario</h1>
    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalMovimiento">
        <i class="fas fa-plus me-1"></i>Nuevo Movimiento
    </button>
</div>

<!-- Tarjetas de resumen -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 id="totalProductos">0</h4>
                        <p class="mb-0">Total Productos</p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-box fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 id="stockBajo">0</h4>
                        <p class="mb-0">Stock Bajo</p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-exclamation-triangle fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-danger">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 id="sinStock">0</h4>
                        <p class="mb-0">Sin Stock</p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-times-circle fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 id="valorInventario">Q0.00</h4>
                        <p class="mb-0">Valor Inventario</p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-dollar-sign fa-2x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Pestañas -->
<ul class="nav nav-tabs" id="inventarioTabs" role="tablist">
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="productos-tab" data-bs-toggle="tab" data-bs-target="#productos" type="button">
            <i class="fas fa-box me-1"></i>Productos
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="movimientos-tab" data-bs-toggle="tab" data-bs-target="#movimientos" type="button">
            <i class="fas fa-exchange-alt me-1"></i>Movimientos
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="stock-bajo-tab" data-bs-toggle="tab" data-bs-target="#stock-bajo" type="button">
            <i class="fas fa-exclamation-triangle me-1"></i>Stock Bajo
        </button>
    </li>
</ul>

<div class="tab-content" id="inventarioTabContent">
    <!-- Tab Productos -->
    <div class="tab-pane fade show active" id="productos" role="tabpanel">
        <div class="card mt-3">
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <input type="text" class="form-control" id="filtroProducto" placeholder="Buscar producto...">
                    </div>
                    <div class="col-md-3">
                        <select class="form-select" id="filtroCategoria">
                            <option value="">Todas las categorías</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <button type="button" class="btn btn-primary w-100" onclick="cargarInventario()">
                            <i class="fas fa-search"></i> Buscar
                        </button>
                    </div>
                </div>
                
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Producto</th>
                                <th>Categoría</th>
                                <th>Stock Actual</th>
                                <th>Stock Mínimo</th>
                                <th>Precio Compra</th>
                                <th>Precio Venta</th>
                                <th>Valor Stock</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody id="tablaInventario">
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Tab Movimientos -->
    <div class="tab-pane fade" id="movimientos" role="tabpanel">
        <div class="card mt-3">
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-3">
                        <input type="date" class="form-control" id="fechaInicio">
                    </div>
                    <div class="col-md-3">
                        <input type="date" class="form-control" id="fechaFin">
                    </div>
                    <div class="col-md-3">
                        <select class="form-select" id="tipoMovimiento">
                            <option value="">Todos los movimientos</option>
                            <option value="entrada">Entrada</option>
                            <option value="salida">Salida</option>
                            <option value="ajuste">Ajuste</option>
                            <option value="devolucion">Devolución</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <button type="button" class="btn btn-primary w-100" onclick="cargarMovimientos()">
                            <i class="fas fa-search"></i> Buscar
                        </button>
                    </div>
                </div>
                
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Fecha</th>
                                <th>Producto</th>
                                <th>Tipo</th>
                                <th>Cantidad</th>
                                <th>Motivo</th>
                                <th>Usuario</th>
                            </tr>
                        </thead>
                        <tbody id="tablaMovimientos">
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Tab Stock Bajo -->
    <div class="tab-pane fade" id="stock-bajo" role="tabpanel">
        <div class="card mt-3">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Producto</th>
                                <th>Categoría</th>
                                <th>Stock Actual</th>
                                <th>Stock Mínimo</th>
                                <th>Diferencia</th>
                                <th>Proveedor</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody id="tablaStockBajo">
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal para movimiento de inventario -->
<div class="modal fade" id="modalMovimiento" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Nuevo Movimiento de Inventario</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="formMovimiento">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="productoMovimiento" class="form-label">Producto *</label>
                        <select class="form-select" id="productoMovimiento" name="producto_id" required>
                            <option value="">Seleccionar producto</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="tipoMovimientoForm" class="form-label">Tipo de Movimiento *</label>
                        <select class="form-select" id="tipoMovimientoForm" name="tipo_movimiento" required>
                            <option value="">Seleccionar tipo</option>
                            <option value="entrada">Entrada</option>
                            <option value="salida">Salida</option>
                            <option value="ajuste">Ajuste</option>
                            <option value="devolucion">Devolución</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="cantidadMovimiento" class="form-label">Cantidad *</label>
                        <input type="number" class="form-control" id="cantidadMovimiento" name="cantidad" step="0.1" required>
                    </div>
                    <div class="mb-3">
                        <label for="motivoMovimiento" class="form-label">Motivo</label>
                        <textarea class="form-control" id="motivoMovimiento" name="motivo" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    cargarResumen();
    cargarInventario();
    cargarCategorias();
    cargarProductosSelect();
    
    // Configurar fechas por defecto
    const hoy = new Date().toISOString().split('T')[0];
    const hace30dias = new Date(Date.now() - 30*24*60*60*1000).toISOString().split('T')[0];
    $('#fechaInicio').val(hace30dias);
    $('#fechaFin').val(hoy);
});

function cargarResumen() {
    $.ajax({
        url: 'api/inventario.php?action=resumen',
        method: 'GET',
        success: function(response) {
            const data = JSON.parse(response);
            $('#totalProductos').text(data.total_productos);
            $('#stockBajo').text(data.stock_bajo);
            $('#sinStock').text(data.sin_stock);
            $('#valorInventario').text('Q' + parseFloat(data.valor_inventario).toFixed(2));
        }
    });
}

function cargarInventario() {
    const filtros = {
        nombre: $('#filtroProducto').val(),
        categoria: $('#filtroCategoria').val()
    };
    
    $.ajax({
        url: 'api/inventario.php',
        method: 'GET',
        data: filtros,
        success: function(response) {
            const productos = JSON.parse(response);
            let html = '';
            
            productos.forEach(function(producto) {
                const stockClass = producto.stock_actual <= producto.stock_minimo ? 'text-danger' : 
                                 producto.stock_actual == 0 ? 'text-danger' : 'text-success';
                const valorStock = producto.stock_actual * producto.precio_compra;
                
                let estadoBadge = '';
                if (producto.stock_actual == 0) {
                    estadoBadge = '<span class="badge bg-danger">Sin Stock</span>';
                } else if (producto.stock_actual <= producto.stock_minimo) {
                    estadoBadge = '<span class="badge bg-warning">Stock Bajo</span>';
                } else {
                    estadoBadge = '<span class="badge bg-success">Normal</span>';
                }
                
                html += `
                    <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                <img src="${producto.imagen}" alt="${producto.nombre}" class="me-2" style="width: 40px; height: 40px; object-fit: cover; border-radius: 4px;">
                                <div>
                                    <strong>${producto.nombre}</strong>
                                    ${producto.codigo_barras ? '<br><small class="text-muted">' + producto.codigo_barras + '</small>' : ''}
                                </div>
                            </div>
                        </td>
                        <td>${producto.categoria_nombre || 'Sin categoría'}</td>
                        <td><span class="${stockClass}">${producto.stock_actual} ${producto.unidad_medida}</span></td>
                        <td>${producto.stock_minimo}</td>
                        <td>Q${parseFloat(producto.precio_compra).toFixed(2)}</td>
                        <td>Q${parseFloat(producto.precio_venta).toFixed(2)}</td>
                        <td>Q${valorStock.toFixed(2)}</td>
                        <td>${estadoBadge}</td>
                        <td>
                            <button class="btn btn-sm btn-outline-primary" onclick="ajustarStock(${producto.id})">
                                <i class="fas fa-edit"></i> Ajustar
                            </button>
                        </td>
                    </tr>
                `;
            });
            
            $('#tablaInventario').html(html);
        }
    });
}

function cargarMovimientos() {
    const filtros = {
        action: 'movimientos',
        fecha_inicio: $('#fechaInicio').val(),
        fecha_fin: $('#fechaFin').val(),
        tipo: $('#tipoMovimiento').val()
    };
    
    $.ajax({
        url: 'api/inventario.php',
        method: 'GET',
        data: filtros,
        success: function(response) {
            const movimientos = JSON.parse(response);
            let html = '';
            
            movimientos.forEach(function(mov) {
                const tipoClass = {
                    'entrada': 'text-success',
                    'salida': 'text-danger',
                    'ajuste': 'text-warning',
                    'devolucion': 'text-info'
                };
                
                const tipoIcon = {
                    'entrada': 'fa-arrow-up',
                    'salida': 'fa-arrow-down',
                    'ajuste': 'fa-edit',
                    'devolucion': 'fa-undo'
                };
                
                html += `
                    <tr>
                        <td>${new Date(mov.fecha).toLocaleString()}</td>
                        <td>${mov.producto_nombre}</td>
                        <td>
                            <span class="${tipoClass[mov.tipo_movimiento]}">
                                <i class="fas ${tipoIcon[mov.tipo_movimiento]} me-1"></i>
                                ${mov.tipo_movimiento.charAt(0).toUpperCase() + mov.tipo_movimiento.slice(1)}
                            </span>
                        </td>
                        <td>${mov.cantidad}</td>
                        <td>${mov.motivo || '-'}</td>
                        <td>${mov.usuario_nombre}</td>
                    </tr>
                `;
            });
            
            $('#tablaMovimientos').html(html);
        }
    });
}

function cargarStockBajo() {
    $.ajax({
        url: 'api/inventario.php?action=stock_bajo',
        method: 'GET',
        success: function(response) {
            const productos = JSON.parse(response);
            let html = '';
            
            productos.forEach(function(producto) {
                const diferencia = producto.stock_minimo - producto.stock_actual;
                
                html += `
                    <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                <img src="${producto.imagen || 'https://via.placeholder.com/40'}" alt="${producto.nombre}" class="me-2" style="width: 40px; height: 40px; object-fit: cover; border-radius: 4px;">
                                <strong>${producto.nombre}</strong>
                            </div>
                        </td>
                        <td>${producto.categoria || 'Sin categoría'}</td>
                        <td><span class="text-danger">${producto.stock_actual}</span></td>
                        <td>${producto.stock_minimo}</td>
                        <td><span class="badge bg-danger">-${diferencia}</span></td>
                        <td>${producto.proveedor || 'Sin proveedor'}</td>
                        <td>
                            <button class="btn btn-sm btn-outline-success" onclick="reabastecer(${producto.id})">
                                <i class="fas fa-plus"></i> Reabastecer
                            </button>
                        </td>
                    </tr>
                `;
            });
            
            $('#tablaStockBajo').html(html);
        }
    });
}

function cargarCategorias() {
    $.ajax({
        url: 'api/productos.php',
        method: 'GET',
        data: { categorias: true },
        success: function(response) {
            // Esta función necesitaría ser implementada en el API
        }
    });
}

function cargarProductosSelect() {
    $.ajax({
        url: 'api/productos.php',
        method: 'GET',
        success: function(response) {
            const productos = JSON.parse(response);
            let html = '<option value="">Seleccionar producto</option>';
            
            productos.forEach(function(producto) {
                html += `<option value="${producto.id}">${producto.nombre} (Stock: ${producto.stock_actual})</option>`;
            });
            
            $('#productoMovimiento').html(html);
        }
    });
}

$('#formMovimiento').on('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    formData.append('usuario_id', 1); // ID del usuario actual
    
    $.ajax({
        url: 'api/inventario.php',
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            const result = JSON.parse(response);
            if (result.success) {
                showAlert('success', 'Éxito', result.message);
                $('#modalMovimiento').modal('hide');
                $('#formMovimiento')[0].reset();
                cargarResumen();
                cargarInventario();
            } else {
                showAlert('error', 'Error', result.message);
            }
        }
    });
});

// Event listeners para las pestañas
$('#movimientos-tab').on('click', function() {
    cargarMovimientos();
});

$('#stock-bajo-tab').on('click', function() {
    cargarStockBajo();
});

function ajustarStock(productoId) {
    $('#productoMovimiento').val(productoId);
    $('#tipoMovimientoForm').val('ajuste');
    $('#modalMovimiento').modal('show');
}

function reabastecer(productoId) {
    $('#productoMovimiento').val(productoId);
    $('#tipoMovimientoForm').val('entrada');
    $('#motivoMovimiento').val('Reabastecimiento por stock bajo');
    $('#modalMovimiento').modal('show');
}
</script>

<?php include 'includes/footer.php'; ?>