<?php
require_once 'config/database.php';
include 'includes/header.php';

$database = new Database();
$db = $database->getConnection();
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="fas fa-truck me-2"></i>Gestión de Proveedores</h1>
    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalProveedor">
        <i class="fas fa-plus me-1"></i>Nuevo Proveedor
    </button>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <input type="text" class="form-control" id="filtroNombre" placeholder="Buscar por nombre...">
            </div>
            <div class="col-md-4">
                <input type="text" class="form-control" id="filtroContacto" placeholder="Buscar por contacto...">
            </div>
            <div class="col-md-2">
                <button type="button" class="btn btn-outline-primary w-100" onclick="cargarProveedores()">
                    <i class="fas fa-search"></i> Buscar
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Tabla de proveedores -->
<div class="card">
    <div class="card-body">
        <div class="loading">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">Cargando...</span>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table table-hover" id="tablaProveedores">
                <thead>
                    <tr>
                        <th>Nombre</th>
                        <th>Contacto</th>
                        <th>Teléfono</th>
                        <th>Email</th>
                        <th>Dirección</th>
                        <th>Estado</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody id="cuerpoTablaProveedores">
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal para agregar/editar proveedor -->
<div class="modal fade" id="modalProveedor" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="tituloModal">Nuevo Proveedor</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="formProveedor">
                <div class="modal-body">
                    <input type="hidden" id="proveedorId" name="id">
                    <div class="mb-3">
                        <label for="nombre" class="form-label">Nombre de la Empresa *</label>
                        <input type="text" class="form-control" id="nombre" name="nombre" required>
                    </div>
                    <div class="mb-3">
                        <label for="contacto" class="form-label">Persona de Contacto</label>
                        <input type="text" class="form-control" id="contacto" name="contacto">
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="telefono" class="form-label">Teléfono</label>
                                <input type="tel" class="form-control" id="telefono" name="telefono">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" class="form-control" id="email" name="email">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="direccion" class="form-label">Dirección</label>
                        <textarea class="form-control" id="direccion" name="direccion" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    cargarProveedores();
    
    $('#filtroNombre, #filtroContacto').on('keyup', function() {
        cargarProveedores();
    });
});

function cargarProveedores() {
    showLoading();
    
    const filtros = {
        nombre: $('#filtroNombre').val(),
        contacto: $('#filtroContacto').val()
    };
    
    $.ajax({
        url: 'api/proveedores.php',
        method: 'GET',
        data: filtros,
        success: function(response) {
            const proveedores = JSON.parse(response);
            let html = '';
            
            proveedores.forEach(function(proveedor) {
                const estadoBadge = proveedor.activo == 1 ? '<span class="badge bg-success">Activo</span>' : '<span class="badge bg-danger">Inactivo</span>';
                
                html += `
                    <tr>
                        <td><strong>${proveedor.nombre}</strong></td>
                        <td>${proveedor.contacto || 'N/A'}</td>
                        <td>${proveedor.telefono || 'N/A'}</td>
                        <td>${proveedor.email || 'N/A'}</td>
                        <td>${proveedor.direccion || 'N/A'}</td>
                        <td>${estadoBadge}</td>
                        <td>
                            <button class="btn btn-sm btn-outline-primary" onclick="editarProveedor(${proveedor.id})">
                                <i class="fas fa-edit"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-danger" onclick="eliminarProveedor(${proveedor.id})">
                                <i class="fas fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                `;
            });
            
            $('#cuerpoTablaProveedores').html(html);
            hideLoading();
        },
        error: function() {
            showAlert('error', 'Error', 'No se pudieron cargar los proveedores');
            hideLoading();
        }
    });
}

$('#formProveedor').on('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    $.ajax({
        url: 'api/proveedores.php',
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            const result = JSON.parse(response);
            if (result.success) {
                showAlert('success', 'Éxito', result.message);
                $('#modalProveedor').modal('hide');
                $('#formProveedor')[0].reset();
                cargarProveedores();
            } else {
                showAlert('error', 'Error', result.message);
            }
        },
        error: function() {
            showAlert('error', 'Error', 'No se pudo guardar el proveedor');
        }
    });
});

function editarProveedor(id) {
    $.ajax({
        url: 'api/proveedores.php?id=' + id,
        method: 'GET',
        success: function(response) {
            const proveedor = JSON.parse(response);
            
            $('#proveedorId').val(proveedor.id);
            $('#nombre').val(proveedor.nombre);
            $('#contacto').val(proveedor.contacto);
            $('#telefono').val(proveedor.telefono);
            $('#email').val(proveedor.email);
            $('#direccion').val(proveedor.direccion);
            
            $('#tituloModal').text('Editar Proveedor');
            $('#modalProveedor').modal('show');
        }
    });
}

function eliminarProveedor(id) {
    confirmAction('¿Eliminar proveedor?', 'Esta acción no se puede deshacer', function() {
        $.ajax({
            url: 'api/proveedores.php',
            method: 'DELETE',
            data: { id: id },
            success: function(response) {
                const result = JSON.parse(response);
                if (result.success) {
                    showAlert('success', 'Éxito', result.message);
                    cargarProveedores();
                } else {
                    showAlert('error', 'Error', result.message);
                }
            }
        });
    });
}

$('#modalProveedor').on('hidden.bs.modal', function() {
    $('#formProveedor')[0].reset();
    $('#proveedorId').val('');
    $('#tituloModal').text('Nuevo Proveedor');
});
</script>

<?php include 'includes/footer.php'; ?>