<?php
require_once 'config/database.php';
include 'includes/header.php';

$database = new Database();
$db = $database->getConnection();
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="fas fa-chart-bar me-2"></i>Reportes y Estadísticas</h1>
    <div class="btn-group">
        <button type="button" class="btn btn-outline-primary" onclick="exportarReporte('pdf')">
            <i class="fas fa-file-pdf me-1"></i>PDF
        </button>
        <button type="button" class="btn btn-outline-success" onclick="exportarReporte('excel')">
            <i class="fas fa-file-excel me-1"></i>Excel
        </button>
    </div>
</div>

<!-- Pestañas de reportes -->
<ul class="nav nav-tabs" id="reportesTabs" role="tablist">
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="ventas-tab" data-bs-toggle="tab" data-bs-target="#ventas" type="button">
            <i class="fas fa-shopping-cart me-1"></i>Ventas
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="productos-tab" data-bs-toggle="tab" data-bs-target="#productos" type="button">
            <i class="fas fa-box me-1"></i>Productos
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="inventario-tab" data-bs-toggle="tab" data-bs-target="#inventario" type="button">
            <i class="fas fa-warehouse me-1"></i>Inventario
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="financiero-tab" data-bs-toggle="tab" data-bs-target="#financiero" type="button">
            <i class="fas fa-dollar-sign me-1"></i>Financiero
        </button>
    </li>
</ul>

<div class="tab-content" id="reportesTabContent">
    <!-- Reporte de Ventas -->
    <div class="tab-pane fade show active" id="ventas" role="tabpanel">
        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-shopping-cart me-2"></i>Reporte de Ventas</h5>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-3">
                        <label for="fechaInicioVentas" class="form-label">Fecha Inicio</label>
                        <input type="date" class="form-control" id="fechaInicioVentas">
                    </div>
                    <div class="col-md-3">
                        <label for="fechaFinVentas" class="form-label">Fecha Fin</label>
                        <input type="date" class="form-control" id="fechaFinVentas">
                    </div>
                    <div class="col-md-3">
                        <label for="vendedorVentas" class="form-label">Vendedor</label>
                        <select class="form-select" id="vendedorVentas">
                            <option value="">Todos los vendedores</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">&nbsp;</label>
                        <button type="button" class="btn btn-primary w-100" onclick="generarReporteVentas()">
                            <i class="fas fa-chart-line"></i> Generar
                        </button>
                    </div>
                </div>
                
                <!-- Resumen de ventas -->
                <div class="row mb-4" id="resumenVentas" style="display: none;">
                    <div class="col-md-3">
                        <div class="card bg-primary text-white">
                            <div class="card-body">
                                <h4 id="totalVentas">0</h4>
                                <p class="mb-0">Total Ventas</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-success text-white">
                            <div class="card-body">
                                <h4 id="montoVentas">Q0.00</h4>
                                <p class="mb-0">Monto Total</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-info text-white">
                            <div class="card-body">
                                <h4 id="promedioVenta">Q0.00</h4>
                                <p class="mb-0">Promedio por Venta</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-warning text-white">
                            <div class="card-body">
                                <h4 id="descuentosVentas">Q0.00</h4>
                                <p class="mb-0">Total Descuentos</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Gráfico de ventas -->
                <div class="row">
                    <div class="col-md-8">
                        <canvas id="graficoVentas" style="display: none;"></canvas>
                    </div>
                    <div class="col-md-4">
                        <div class="table-responsive">
                            <table class="table table-sm" id="tablaVentasDetalle" style="display: none;">
                                <thead>
                                    <tr>
                                        <th>Fecha</th>
                                        <th>Ventas</th>
                                        <th>Monto</th>
                                    </tr>
                                </thead>
                                <tbody id="cuerpoVentasDetalle">
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Reporte de Productos -->
    <div class="tab-pane fade" id="productos" role="tabpanel">
        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-box me-2"></i>Reporte de Productos</h5>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label for="categoriaProductos" class="form-label">Categoría</label>
                        <select class="form-select" id="categoriaProductos">
                            <option value="">Todas las categorías</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label for="tipoReporteProductos" class="form-label">Tipo de Reporte</label>
                        <select class="form-select" id="tipoReporteProductos">
                            <option value="mas_vendidos">Más Vendidos</option>
                            <option value="menos_vendidos">Menos Vendidos</option>
                            <option value="stock_bajo">Stock Bajo</option>
                            <option value="sin_movimiento">Sin Movimiento</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">&nbsp;</label>
                        <button type="button" class="btn btn-primary w-100" onclick="generarReporteProductos()">
                            <i class="fas fa-chart-bar"></i> Generar
                        </button>
                    </div>
                </div>
                
                <div class="table-responsive">
                    <table class="table table-hover" id="tablaReporteProductos" style="display: none;">
                        <thead id="cabeceraProdutos">
                        </thead>
                        <tbody id="cuerpoReporteProductos">
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Reporte de Inventario -->
    <div class="tab-pane fade" id="inventario" role="tabpanel">
        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-warehouse me-2"></i>Reporte de Inventario</h5>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label for="tipoMovimiento" class="form-label">Tipo de Movimiento</label>
                        <select class="form-select" id="tipoMovimiento">
                            <option value="">Todos</option>
                            <option value="entrada">Entradas</option>
                            <option value="salida">Salidas</option>
                            <option value="ajuste">Ajustes</option>
                            <option value="devolucion">Devoluciones</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="fechaInicioInventario" class="form-label">Fecha Inicio</label>
                        <input type="date" class="form-control" id="fechaInicioInventario">
                    </div>
                    <div class="col-md-3">
                        <label for="fechaFinInventario" class="form-label">Fecha Fin</label>
                        <input type="date" class="form-control" id="fechaFinInventario">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">&nbsp;</label>
                        <button type="button" class="btn btn-primary w-100" onclick="generarReporteInventario()">
                            <i class="fas fa-list"></i> Generar
                        </button>
                    </div>
                </div>
                
                <div class="table-responsive">
                    <table class="table table-hover" id="tablaReporteInventario" style="display: none;">
                        <thead>
                            <tr>
                                <th>Fecha</th>
                                <th>Producto</th>
                                <th>Tipo</th>
                                <th>Cantidad</th>
                                <th>Motivo</th>
                                <th>Usuario</th>
                            </tr>
                        </thead>
                        <tbody id="cuerpoReporteInventario">
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Reporte Financiero -->
    <div class="tab-pane fade" id="financiero" role="tabpanel">
        <div class="card mt-3">
            <div class="card-header">
                <h5><i class="fas fa-dollar-sign me-2"></i>Reporte Financiero</h5>
            </div>
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label for="fechaInicioFinanciero" class="form-label">Fecha Inicio</label>
                        <input type="date" class="form-control" id="fechaInicioFinanciero">
                    </div>
                    <div class="col-md-4">
                        <label for="fechaFinFinanciero" class="form-label">Fecha Fin</label>
                        <input type="date" class="form-control" id="fechaFinFinanciero">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">&nbsp;</label>
                        <button type="button" class="btn btn-primary w-100" onclick="generarReporteFinanciero()">
                            <i class="fas fa-calculator"></i> Generar
                        </button>
                    </div>
                </div>
                
                <!-- Resumen financiero -->
                <div class="row mb-4" id="resumenFinanciero" style="display: none;">
                    <div class="col-md-3">
                        <div class="card bg-success text-white">
                            <div class="card-body">
                                <h4 id="totalIngresos">Q0.00</h4>
                                <p class="mb-0">Total Ingresos</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-danger text-white">
                            <div class="card-body">
                                <h4 id="totalGastos">Q0.00</h4>
                                <p class="mb-0">Total Gastos</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-info text-white">
                            <div class="card-body">
                                <h4 id="utilidadBruta">Q0.00</h4>
                                <p class="mb-0">Utilidad Bruta</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-warning text-white">
                            <div class="card-body">
                                <h4 id="margenUtilidad">0%</h4>
                                <p class="mb-0">Margen de Utilidad</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
$(document).ready(function() {
    // Configurar fechas por defecto
    const hoy = new Date().toISOString().split('T')[0];
    const hace30dias = new Date(Date.now() - 30*24*60*60*1000).toISOString().split('T')[0];
    
    $('#fechaInicioVentas, #fechaInicioInventario, #fechaInicioFinanciero').val(hace30dias);
    $('#fechaFinVentas, #fechaFinInventario, #fechaFinFinanciero').val(hoy);
    
    cargarVendedores();
    cargarCategorias();
});

function cargarVendedores() {
    $.ajax({
        url: 'api/usuarios.php',
        method: 'GET',
        data: { rol: 'cajero' },
        success: function(response) {
            const usuarios = JSON.parse(response);
            let html = '<option value="">Todos los vendedores</option>';
            
            usuarios.forEach(function(usuario) {
                html += `<option value="${usuario.id}">${usuario.nombre} ${usuario.apellido || ''}</option>`;
            });
            
            $('#vendedorVentas').html(html);
        }
    });
}

function cargarCategorias() {
    $.ajax({
        url: 'api/productos.php',
        method: 'GET',
        success: function(response) {
            // Esta función necesitaría implementarse para obtener categorías
        }
    });
}

function generarReporteVentas() {
    const filtros = {
        action: 'ventas',
        fecha_inicio: $('#fechaInicioVentas').val(),
        fecha_fin: $('#fechaFinVentas').val(),
        vendedor_id: $('#vendedorVentas').val()
    };
    
    $.ajax({
        url: 'api/reportes.php',
        method: 'GET',
        data: filtros,
        success: function(response) {
            const data = JSON.parse(response);
            
            // Mostrar resumen
            $('#totalVentas').text(data.resumen.total_ventas);
            $('#montoVentas').text('Q' + parseFloat(data.resumen.monto_total).toFixed(2));
            $('#promedioVenta').text('Q' + parseFloat(data.resumen.promedio_venta).toFixed(2));
            $('#descuentosVentas').text('Q' + parseFloat(data.resumen.total_descuentos).toFixed(2));
            
            $('#resumenVentas').show();
            
            // Mostrar tabla detalle
            let html = '';
            data.detalle.forEach(function(item) {
                html += `
                    <tr>
                        <td>${item.fecha}</td>
                        <td>${item.num_ventas}</td>
                        <td>Q${parseFloat(item.total_ventas).toFixed(2)}</td>
                    </tr>
                `;
            });
            $('#cuerpoVentasDetalle').html(html);
            $('#tablaVentasDetalle').show();
            
            // Crear gráfico
            crearGraficoVentas(data.detalle);
        }
    });
}

function generarReporteProductos() {
    const filtros = {
        action: 'productos',
        categoria: $('#categoriaProductos').val(),
        tipo: $('#tipoReporteProductos').val()
    };
    
    $.ajax({
        url: 'api/reportes.php',
        method: 'GET',
        data: filtros,
        success: function(response) {
            const data = JSON.parse(response);
            
            // Configurar cabecera según el tipo
            let cabecera = '';
            switch(filtros.tipo) {
                case 'mas_vendidos':
                case 'menos_vendidos':
                    cabecera = `
                        <tr>
                            <th>Producto</th>
                            <th>Categoría</th>
                            <th>Cantidad Vendida</th>
                            <th>Ingresos</th>
                        </tr>
                    `;
                    break;
                case 'stock_bajo':
                    cabecera = `
                        <tr>
                            <th>Producto</th>
                            <th>Stock Actual</th>
                            <th>Stock Mínimo</th>
                            <th>Diferencia</th>
                        </tr>
                    `;
                    break;
            }
            
            $('#cabeceraProdutos').html(cabecera);
            
            // Llenar datos
            let html = '';
            data.forEach(function(item) {
                switch(filtros.tipo) {
                    case 'mas_vendidos':
                    case 'menos_vendidos':
                        html += `
                            <tr>
                                <td>${item.nombre}</td>
                                <td>${item.categoria || 'Sin categoría'}</td>
                                <td>${item.total_vendido}</td>
                                <td>Q${parseFloat(item.total_ingresos).toFixed(2)}</td>
                            </tr>
                        `;
                        break;
                    case 'stock_bajo':
                        html += `
                            <tr>
                                <td>${item.nombre}</td>
                                <td><span class="text-danger">${item.stock_actual}</span></td>
                                <td>${item.stock_minimo}</td>
                                <td><span class="badge bg-danger">-${item.stock_minimo - item.stock_actual}</span></td>
                            </tr>
                        `;
                        break;
                }
            });
            
            $('#cuerpoReporteProductos').html(html);
            $('#tablaReporteProductos').show();
        }
    });
}

function generarReporteInventario() {
    const filtros = {
        action: 'inventario',
        tipo_movimiento: $('#tipoMovimiento').val(),
        fecha_inicio: $('#fechaInicioInventario').val(),
        fecha_fin: $('#fechaFinInventario').val()
    };
    
    $.ajax({
        url: 'api/reportes.php',
        method: 'GET',
        data: filtros,
        success: function(response) {
            const data = JSON.parse(response);
            let html = '';
            
            data.forEach(function(mov) {
                const tipoClass = {
                    'entrada': 'text-success',
                    'salida': 'text-danger',
                    'ajuste': 'text-warning',
                    'devolucion': 'text-info'
                };
                
                html += `
                    <tr>
                        <td>${new Date(mov.fecha).toLocaleDateString()}</td>
                        <td>${mov.producto_nombre}</td>
                        <td><span class="${tipoClass[mov.tipo_movimiento]}">${mov.tipo_movimiento}</span></td>
                        <td>${mov.cantidad}</td>
                        <td>${mov.motivo || '-'}</td>
                        <td>${mov.usuario_nombre}</td>
                    </tr>
                `;
            });
            
            $('#cuerpoReporteInventario').html(html);
            $('#tablaReporteInventario').show();
        }
    });
}

function generarReporteFinanciero() {
    const filtros = {
        action: 'financiero',
        fecha_inicio: $('#fechaInicioFinanciero').val(),
        fecha_fin: $('#fechaFinFinanciero').val()
    };
    
    $.ajax({
        url: 'api/reportes.php',
        method: 'GET',
        data: filtros,
        success: function(response) {
            const data = JSON.parse(response);
            
            $('#totalIngresos').text('Q' + parseFloat(data.total_ingresos).toFixed(2));
            $('#totalGastos').text('Q' + parseFloat(data.total_gastos).toFixed(2));
            $('#utilidadBruta').text('Q' + parseFloat(data.utilidad_bruta).toFixed(2));
            $('#margenUtilidad').text(parseFloat(data.margen_utilidad).toFixed(1) + '%');
            
            $('#resumenFinanciero').show();
        }
    });
}

function crearGraficoVentas(datos) {
    const ctx = document.getElementById('graficoVentas').getContext('2d');
    
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: datos.map(item => item.fecha),
            datasets: [{
                label: 'Ventas Diarias',
                data: datos.map(item => item.total_ventas),
                borderColor: 'rgb(75, 192, 192)',
                backgroundColor: 'rgba(75, 192, 192, 0.2)',
                tension: 0.1
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return 'Q' + value.toFixed(2);
                        }
                    }
                }
            }
        }
    });
    
    $('#graficoVentas').show();
}

function exportarReporte(formato) {
    showAlert('info', 'Exportando', 'Funcionalidad de exportación en desarrollo');
}
</script>

<?php include 'includes/footer.php'; ?>