<?php
require_once 'config/database.php';
include 'includes/header.php';

$database = new Database();
$db = $database->getConnection();
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="fas fa-user-cog me-2"></i>Gestión de Usuarios</h1>
    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalUsuario">
        <i class="fas fa-plus me-1"></i>Nuevo Usuario
    </button>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <div class="row">
            <div class="col-md-4">
                <input type="text" class="form-control" id="filtroNombre" placeholder="Buscar por nombre...">
            </div>
            <div class="col-md-3">
                <input type="text" class="form-control" id="filtroUsername" placeholder="Buscar por usuario...">
            </div>
            <div class="col-md-3">
                <select class="form-select" id="filtroRol">
                    <option value="">Todos los roles</option>
                    <option value="admin">Administrador</option>
                    <option value="supervisor">Supervisor</option>
                    <option value="cajero">Cajero</option>
                    <option value="empleado">Empleado</option>
                </select>
            </div>
            <div class="col-md-2">
                <button type="button" class="btn btn-outline-primary w-100" onclick="cargarUsuarios()">
                    <i class="fas fa-search"></i> Buscar
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Tabla de usuarios -->
<div class="card">
    <div class="card-body">
        <div class="loading">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">Cargando...</span>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table table-hover" id="tablaUsuarios">
                <thead>
                    <tr>
                        <th>Nombre</th>
                        <th>Usuario</th>
                        <th>Email</th>
                        <th>Rol</th>
                        <th>Teléfono</th>
                        <th>Último Acceso</th>
                        <th>Estado</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody id="cuerpoTablaUsuarios">
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal para agregar/editar usuario -->
<div class="modal fade" id="modalUsuario" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="tituloModal">Nuevo Usuario</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="formUsuario">
                <div class="modal-body">
                    <input type="hidden" id="usuarioId" name="id">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="nombre" class="form-label">Nombre *</label>
                                <input type="text" class="form-control" id="nombre" name="nombre" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="apellido" class="form-label">Apellido</label>
                                <input type="text" class="form-control" id="apellido" name="apellido">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="username" class="form-label">Usuario *</label>
                                <input type="text" class="form-control" id="username" name="username" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" class="form-control" id="email" name="email">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="password" class="form-label">Contraseña *</label>
                                <input type="password" class="form-control" id="password" name="password">
                                <small class="text-muted" id="passwordHelp">Dejar vacío para mantener la contraseña actual</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="rol" class="form-label">Rol *</label>
                                <select class="form-select" id="rol" name="rol" required>
                                    <option value="">Seleccionar rol</option>
                                    <option value="admin">Administrador</option>
                                    <option value="supervisor">Supervisor</option>
                                    <option value="cajero">Cajero</option>
                                    <option value="empleado">Empleado</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="telefono" class="form-label">Teléfono</label>
                        <input type="tel" class="form-control" id="telefono" name="telefono">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    cargarUsuarios();
    
    $('#filtroNombre, #filtroUsername').on('keyup', function() {
        cargarUsuarios();
    });
});

function cargarUsuarios() {
    showLoading();
    
    const filtros = {
        nombre: $('#filtroNombre').val(),
        username: $('#filtroUsername').val(),
        rol: $('#filtroRol').val()
    };
    
    $.ajax({
        url: 'api/usuarios.php',
        method: 'GET',
        data: filtros,
        success: function(response) {
            const usuarios = JSON.parse(response);
            let html = '';
            
            usuarios.forEach(function(usuario) {
                const estadoBadge = usuario.activo == 1 ? '<span class="badge bg-success">Activo</span>' : '<span class="badge bg-danger">Inactivo</span>';
                
                const rolBadges = {
                    'admin': '<span class="badge bg-danger">Administrador</span>',
                    'supervisor': '<span class="badge bg-warning">Supervisor</span>',
                    'cajero': '<span class="badge bg-info">Cajero</span>',
                    'empleado': '<span class="badge bg-secondary">Empleado</span>'
                };
                
                const ultimoAcceso = usuario.ultimo_acceso ? 
                    new Date(usuario.ultimo_acceso).toLocaleString() : 'Nunca';
                
                html += `
                    <tr>
                        <td><strong>${usuario.nombre} ${usuario.apellido || ''}</strong></td>
                        <td>${usuario.username}</td>
                        <td>${usuario.email || 'N/A'}</td>
                        <td>${rolBadges[usuario.rol] || usuario.rol}</td>
                        <td>${usuario.telefono || 'N/A'}</td>
                        <td><small>${ultimoAcceso}</small></td>
                        <td>${estadoBadge}</td>
                        <td>
                            <button class="btn btn-sm btn-outline-primary" onclick="editarUsuario(${usuario.id})">
                                <i class="fas fa-edit"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-danger" onclick="eliminarUsuario(${usuario.id})">
                                <i class="fas fa-trash"></i>
                            </button>
                        </td>
                    </tr>
                `;
            });
            
            $('#cuerpoTablaUsuarios').html(html);
            hideLoading();
        },
        error: function() {
            showAlert('error', 'Error', 'No se pudieron cargar los usuarios');
            hideLoading();
        }
    });
}

$('#formUsuario').on('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    $.ajax({
        url: 'api/usuarios.php',
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function(response) {
            const result = JSON.parse(response);
            if (result.success) {
                showAlert('success', 'Éxito', result.message);
                $('#modalUsuario').modal('hide');
                $('#formUsuario')[0].reset();
                cargarUsuarios();
            } else {
                showAlert('error', 'Error', result.message);
            }
        },
        error: function() {
            showAlert('error', 'Error', 'No se pudo guardar el usuario');
        }
    });
});

function editarUsuario(id) {
    $.ajax({
        url: 'api/usuarios.php?id=' + id,
        method: 'GET',
        success: function(response) {
            const usuario = JSON.parse(response);
            
            $('#usuarioId').val(usuario.id);
            $('#nombre').val(usuario.nombre);
            $('#apellido').val(usuario.apellido);
            $('#username').val(usuario.username);
            $('#email').val(usuario.email);
            $('#rol').val(usuario.rol);
            $('#telefono').val(usuario.telefono);
            $('#password').val('');
            
            $('#passwordHelp').show();
            $('#password').removeAttr('required');
            
            $('#tituloModal').text('Editar Usuario');
            $('#modalUsuario').modal('show');
        }
    });
}

function eliminarUsuario(id) {
    confirmAction('¿Eliminar usuario?', 'Esta acción no se puede deshacer', function() {
        $.ajax({
            url: 'api/usuarios.php',
            method: 'DELETE',
            data: { id: id },
            success: function(response) {
                const result = JSON.parse(response);
                if (result.success) {
                    showAlert('success', 'Éxito', result.message);
                    cargarUsuarios();
                } else {
                    showAlert('error', 'Error', result.message);
                }
            }
        });
    });
}

$('#modalUsuario').on('hidden.bs.modal', function() {
    $('#formUsuario')[0].reset();
    $('#usuarioId').val('');
    $('#tituloModal').text('Nuevo Usuario');
    $('#passwordHelp').hide();
    $('#password').attr('required', 'required');
});
</script>

<?php include 'includes/footer.php'; ?>